; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - In game variables
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Layout
; -------------------------------------------------------------------------------------------------------------- ;
BH_MemVicBas                = $0000                 ; bank0: $0000-$3fff
BH_MemScreenStatus          = BH_MemVicBas + $0400  ; 
BH_MemBasic                 = BH_MemVicBas + $0800  ; 
BH_MemCodeLo                = $1e00                 ; $1e00-$4003
;BH_MemScreenSave            = $3c00                 ; to 3fff
BH_MemCodeSprites           = $3f00                 ; to $5e03 - will be copied to $e000-$fdff
BH_MemVicGfx                = $4000                 ; bank2: $4000-$7fff
BH_MemCharSet               = BH_MemVicGfx + $0000  ; 
BH_MemScreenSetA            = BH_MemVicGfx + $0800  ; TabVicMemControlSetA
BH_MemScreenSetB            = BH_MemVicGfx + $0c00  ; TabVicMemControlSetB
BH_MemSprites               = BH_MemVicGfx + $1000  ; 
BH_MemCodeHi                = $6580                 ; up to $c002
BH_Mem_unused_01            = $c003                 ; up to $cfff
BH_MemSpritesData           = $e000                 ; 
BH_Mem_unused_02            = $fe00                 ; up to $feff
BH_MemKernal                = $ff00                 ; up to $ffff

BH_MemScreenSave            = $c000                ; .hbu003.
BH_MemScreenSaveLen           = BH_Scrn_Stat_Rows * BH_Scrn_RowLen ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Screens
; -------------------------------------------------------------------------------------------------------------- ;
BH_Scrn_GfxCharSets         = BH_MemCharSet           ; $4000

BH_Scrn_Gfx                 = BH_MemScreenSetA        ; $4800
BH_Scrn_Gfx_A               = BH_MemScreenSetA        ; 
BH_Scrn_Gfx_B               = BH_MemScreenSetB        ; $4c00
BH_Scrn_Gfx_Save            = BH_MemScreenSave        ; $c000
BH_Scrn_Gfx_Rows              = $14                   ; 
BH_Scrn_Stat_Rows             = $05                   ; 

BH_Scrn_RowLen              = $28                     ; 
BH_Scrn_Row_01              = $00 * BH_Scrn_RowLen    ; $000 - 01 - $14 graphics rows
BH_Scrn_Row_02              = $01 * BH_Scrn_RowLen    ; $028 - 02
BH_Scrn_Row_03              = $02 * BH_Scrn_RowLen    ; $050 - 03
BH_Scrn_Row_04              = $03 * BH_Scrn_RowLen    ; $078 - 04
BH_Scrn_Row_05              = $04 * BH_Scrn_RowLen    ; $0a0 - 05
BH_Scrn_Row_06              = $05 * BH_Scrn_RowLen    ; $0c8 - 06
BH_Scrn_Row_07              = $06 * BH_Scrn_RowLen    ; $0f0 - 07
BH_Scrn_Row_08              = $07 * BH_Scrn_RowLen    ; $118 - 08
BH_Scrn_Row_09              = $08 * BH_Scrn_RowLen    ; $140 - 09
BH_Scrn_Row_0a              = $09 * BH_Scrn_RowLen    ; $168 - 10
BH_Scrn_Row_0b              = $0a * BH_Scrn_RowLen    ; $190 - 11
BH_Scrn_Row_0c              = $0b * BH_Scrn_RowLen    ; $1b8 - 12
BH_Scrn_Row_0d              = $0c * BH_Scrn_RowLen    ; $1e0 - 13
BH_Scrn_Row_0e              = $0d * BH_Scrn_RowLen    ; $208 - 14
BH_Scrn_Row_0f              = $0e * BH_Scrn_RowLen    ; $230 - 15
BH_Scrn_Row_10              = $0f * BH_Scrn_RowLen    ; $258 - 16
BH_Scrn_Row_11              = $10 * BH_Scrn_RowLen    ; $280 - 17
BH_Scrn_Row_12              = $11 * BH_Scrn_RowLen    ; $2a8 - 18
BH_Scrn_Row_13              = $12 * BH_Scrn_RowLen    ; $2d0 - 19
BH_Scrn_Row_14              = $13 * BH_Scrn_RowLen    ; $2f8 - 20

BH_Scrn_Row_15              = $14 * BH_Scrn_RowLen    ; $320 - 21 - $05 status rows
BH_Scrn_Row_16              = $15 * BH_Scrn_RowLen    ; $348 - 22
BH_Scrn_Row_17              = $16 * BH_Scrn_RowLen    ; $370 - 23
BH_Scrn_Row_18              = $17 * BH_Scrn_RowLen    ; $398 - 24
BH_Scrn_Row_19              = $18 * BH_Scrn_RowLen    ; $3c0 - 25 - 3e7

BH_Scrn_Stat_Save           = BH_MemScreenSave        ; 
BH_Scrn_Stat_Save_Data      = BH_Scrn_Stat_Save + $0100 ; 
BH_Scrn_Stat_Save_Color     = BH_Scrn_Stat_Save + $0200 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter Screen Updates
; -------------------------------------------------------------------------------------------------------------- ;
BH_Scrn_Gfx                 = BH_MemScreenSetA        ; $4800

BH_Scrn_Gfx_OffCloseBayTop  = BH_Scrn_Row_0c + $1a    ; close bay - top island
BH_Scrn_Gfx_OffCloseBayMid  = BH_Scrn_Row_0d + $1c    ; close bay - mid island
BH_Scrn_Gfx_OffCloseBayBot  = BH_Scrn_Row_0e + $1e    ; close bay - bot island
BH_Scrn_Gfx_OffClrCarrier   = BH_Scrn_Row_0c + $16    ; clear carrier top/sky/water
BH_Scrn_Gfx_OffClrVessel_1  = BH_Scrn_Row_0c + $04    ; clear vessel 1
BH_Scrn_Gfx_OffClrVessel_2  = BH_Scrn_Row_0d + $0b    ; clear vessel 2
BH_Scrn_Gfx_OffClrVessel_3  = BH_Scrn_Row_0d + $1e    ; clear vessel 3
BH_Scrn_Gfx_OffClrVessel_4  = BH_Scrn_Row_0e + $23    ; clear vessel 4
BH_Scrn_Gfx_OffHillCapTop   = BH_Scrn_Row_04 + $13    ; hill turret cap ruin - row 01
BH_Scrn_Gfx_OffHillCapBot   = BH_Scrn_Row_05 + $12    ; hill turret cap ruin - row 02
; -------------------------------------------------------------------------------------------------------------- ;
; Status Screen Updates
; -------------------------------------------------------------------------------------------------------------- ;
BH_Scrn_Stat                = BH_MemScreenStatus      ; $0400

BH_Scrn_Stat_OffAmmo          = $1c                   ; global foa all rows
BH_Scrn_Stat_LenAmmo          = $0a                   ; 

BH_Scrn_Stat_Row_01         = BH_Scrn_Row_15          ; $0320
BH_Scrn_Stat_OffLevelTxt      = $02                   ; 
BH_Scrn_Stat_OffLevel         = $0b                   ; 
BH_Scrn_Stat_OffLevel1      = BH_Scrn_Stat_Row_01 + BH_Scrn_Stat_OffLevel + $00 ; 
BH_Scrn_Stat_OffBox           = $12                   ; 
BH_Scrn_Stat_OffInfoBruce     = $07                   ; 
BH_Scrn_Stat_OffAmmoTxt       = BH_Scrn_Stat_OffAmmo  ; header

BH_Scrn_Stat_Row_02         = BH_Scrn_Row_16          ; $0348
BH_Scrn_Stat_OffScoreTxtGO    = $0e                   ; Game Over
BH_Scrn_Stat_OffPlayerTxt     = $02                   ; 
BH_Scrn_Stat_OffPlayer        = $0b                   ; 
BH_Scrn_Stat_OffPlayer1     = BH_Scrn_Stat_Row_02 + BH_Scrn_Stat_OffPlayer + $00 ; 
BH_Scrn_Stat_OffScoreGO       = $14                   ; Game Over
BH_Scrn_Stat_OffScoreOver   = BH_Scrn_Stat_Row_02 + BH_Scrn_Stat_OffScoreGO + $00 ; 
BH_Scrn_Stat_LenAmmoFlackTxt  = $04                   ; 
BH_Scrn_Stat_OffAmmoFlackTxt  = BH_Scrn_Stat_OffAmmo - BH_Scrn_Stat_LenAmmoFlackTxt ; 
BH_Scrn_Stat_LenAmmoFlackCube = BH_Scrn_Stat_LenAmmo  ; 
BH_Scrn_Stat_OffAmmoFlackCube = BH_Scrn_Stat_Row_02 + BH_Scrn_Stat_OffAmmo ; 
BH_Scrn_Stat_LenAmmoTankTxt   = $05                   ; 
BH_Scrn_Stat_OffAmmoTankTxt = BH_Scrn_Stat_OffAmmo - BH_Scrn_Stat_LenAmmoTankTxt ; 
BH_Scrn_Stat_LenAmmoTankCube= BH_Scrn_Stat_LenAmmo    ; 

BH_Scrn_Stat_Row_03         = BH_Scrn_Row_17          ; $0370
BH_Scrn_Stat_LenScore         = $06                   ; 
BH_Scrn_Stat_OffScore         = $08                   ; 
BH_Scrn_Stat_OffScore100000 = BH_Scrn_Stat_Row_03 + BH_Scrn_Stat_OffScore + $00 ; 
BH_Scrn_Stat_OffScore10000  = BH_Scrn_Stat_Row_03 + BH_Scrn_Stat_OffScore + $01 ; 
BH_Scrn_Stat_OffScore1000   = BH_Scrn_Stat_Row_03 + BH_Scrn_Stat_OffScore + $02 ; 
BH_Scrn_Stat_OffScore100    = BH_Scrn_Stat_Row_03 + BH_Scrn_Stat_OffScore + $03 ; 
BH_Scrn_Stat_OffScore10     = BH_Scrn_Stat_Row_03 + BH_Scrn_Stat_OffScore + $04 ; 
BH_Scrn_Stat_OffScore1      = BH_Scrn_Stat_Row_03 + BH_Scrn_Stat_OffScore + $05 ; 
BH_Scrn_Stat_OffScoreGame   = BH_Scrn_Stat_Row_03 + BH_Scrn_Stat_OffScore - $01 ; 
BH_Scrn_Stat_OffInfoCR        = $07                   ; 
BH_Scrn_Stat_LenMapDestr      = $0e                   ; 
BH_Scrn_Stat_OffMapDestr      = $18                   ; 
BH_Scrn_Stat_LenAmmoShipTxt   = $05                   ; 
BH_Scrn_Stat_OffAmmoShipTxt   = BH_Scrn_Stat_OffAmmo - BH_Scrn_Stat_LenAmmoShipTxt ; 
BH_Scrn_Stat_LenAmmoShipCube  = BH_Scrn_Stat_LenAmmo  ; 
BH_Scrn_Stat_OffAmmoShipCube  = BH_Scrn_Stat_OffAmmo  ; 

BH_Scrn_Stat_Row_04         = BH_Scrn_Row_18          ; $0398
BH_Scrn_Stat_OffScoreTxt      = $02                   ; 
BH_Scrn_Stat_OffGetReady      = $09                   ; 
BH_Scrn_Stat_OffTextGO        = $0a                   ; 
BH_Scrn_Stat_OffPlayerNo      = $15                   ; 
BH_Scrn_Stat_OffDegElevTxt    = $18                   ; 
BH_Scrn_Stat_OffDegElev       = $1b                   ; 
BH_Scrn_Stat_OffDeg           = $16                   ; 
BH_Scrn_Stat_OffDeg10       = BH_Scrn_Stat_Row_04 + BH_Scrn_Stat_OffDeg + $00 ; 
BH_Scrn_Stat_OffDeg1        = BH_Scrn_Stat_Row_04 + BH_Scrn_Stat_OffDeg + $01 ; 
BH_Scrn_Stat_OffDeg_        = BH_Scrn_Stat_Row_04 + BH_Scrn_Stat_OffDeg + $02 ; 
BH_Scrn_Stat_OffDeg_1       = BH_Scrn_Stat_Row_04 + BH_Scrn_Stat_OffDeg + $03 ; 

BH_Scrn_Stat_Row_05         = BH_Scrn_Row_19          ; $03c0
BH_Scrn_Stat_OffShipsTxt      = $04                   ; 
BH_Scrn_Stat_OffShips         = $0a                   ; 
BH_Scrn_Stat_OffShipsO      = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffShips + $00 ; 
BH_Scrn_Stat_OffTanks         = $0a                   ; 
BH_Scrn_Stat_OffTanksO      = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffTanks + $00 ; 
BH_Scrn_Stat_OffTanksTxt      = $04                   ; 
BH_Scrn_Stat_LenMapAerial     = $0c                   ; 
BH_Scrn_Stat_OffMapAerial     = $16                   ; 
BH_Scrn_Stat_LenDamage        = $06                   ; 
BH_Scrn_Stat_OffDamage        = $16                   ; 
BH_Scrn_Stat_OffDamage10    = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffDamage + BH_Scrn_Stat_LenDamage + $01 ; 
BH_Scrn_Stat_OffDamage1     = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffDamage + BH_Scrn_Stat_LenDamage + $02 ; 
BH_Scrn_Stat_OffDist          = $15                   ; 
BH_Scrn_Stat_OffDist10000   = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffDist + $00 ; 
BH_Scrn_Stat_OffDist1000    = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffDist + $01 ; 
BH_Scrn_Stat_OffDist100     = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffDist + $02 ; 
BH_Scrn_Stat_OffDist10      = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffDist + $03 ; 
BH_Scrn_Stat_OffDist1       = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffDist + $04 ; 
BH_Scrn_Stat_OffDist_       = BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_OffDist + $05 ; 
BH_Scrn_Stat_LenDist          = $0e                   ; 
BH_Scrn_Stat_OffDistLong      = $1b                   ; 
BH_Scrn_Stat_OffDistShort     = BH_Scrn_Stat_OffDistLong ; 

BH_Scrn_Stat_OffTime          = $12                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Misc
; -------------------------------------------------------------------------------------------------------------- ;
BH_BayPassageLeftPosX       = $e8 ; bay opening left border        
BH_BayRightAdjustPosY       = $13 ; adjustement if entered through opening - added $03 - no seek throughs anymore
BH_BayFleetMyStartPosX_Msb  = $00 ; $01 ; 
BH_BayFleetMyStartPosX      = $c0 ; $40 ; startpos chase myFleet in bay
BH_BayFleetMyStartPosY      = BH_BayFleetHitCavePosY ; $32 ; 
BH_BayFleetEnemyStartPosX   = $6e ; startpos chase myFleet in bay
BH_BayFleetEnemyStartPosY   = $b2 ; 
BH_BayFleetHitCavePosX      = $83 ; 
BH_BayFleetHitCavePosY      = $4a ; 
BH_BayFleetChaseGoPosX      = $a0 ; startpos chase myFleet in bay
BH_BayFleetChaseGoPosY      = $a2 ; 
BH_BayFleetLeftCavePosX     = $a0 ; startpos chase myFleet in bay
BH_BayFleetLeftCavePosY     = $a2 ; 
BH_BayFleetHitBeachPosX     = $62 ; myFleet touches the beach
BH_BayFleetHitBeachPosY     = $b4 ; 
BH_FleetOverlayPosX         = $08 ; both fleets mix
BH_FleetOverlayPosY         = $08 ; 
BH_BeachMinPosX             = $60 ; 
BH_BeachMaxPosX             = BH_BeachMinPosX + $08 ; 
BH_BeachMinPosY             = $b2 ; 
BH_BeachMaxPosY             = BH_BeachMinPosY + $08 ; 
BH_ShipsMax                 = $0a ; 
BH_TanksMax                 = $08 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Sprite Numbers
; -------------------------------------------------------------------------------------------------------------- ;
BH_BeachSprtNoMyTank        = $00 ; $00
BH_BeachSprtNoMyShot        = $01 ; $02
BH_BeachSprtNoEneShot       = $02 ; $04
BH_BeachSprtNoCannon        = $03 ; $08
BH_BeachSprtNoTankE         = $04 ; $10
BH_BeachSprtNoMacGun        = $05 ; $20
BH_BeachSprtNoTurret        = $06 ; $40
BH_BeachSprtNo_07           = $07 ; $80
; -------------------------------------------------------------------------------------------------------------- ;
; Colors: Sprite
; -------------------------------------------------------------------------------------------------------------- ;
BH_SprtColorCaveTorp_1      = ORANGE   ; 
BH_SprtColorCaveTorp_2      = LT_GREEN ; 
BH_SprtColorCaveTorp_3      = PURPLE   ; 
BH_SprtColorCaveTorp_4      = LT_BLUE  ; .hbu008. - follower torpedo #4
BH_SprtColorFleetMy         = WHITE    ; 
BH_SprtColorFleetEnemy      = WHITE    ; 
BH_SprtColorShip            = WHITE    ; 
BH_SprtColorShipSplash      = WHITE    ; 
BH_SprtColorShipCannon      = WHITE    ; 
BH_SprtColorShipBullet      = ORANGE   ; 
BH_SprtColorShipExplode     = ORANGE   ; 
BH_SprtColorShipExplodeBkgr = RED      ; 
BH_SprtColorPlane           = BLACK    ; 
BH_SprtColorPlaneBullet     = ORANGE   ; 
BH_SprtColorPlaneExplode    = YELLOW   ; 
BH_SprtColorPlaneExpl_MC0   = ORANGE   ; 
BH_SprtColorPlaneExpl_MC1   = WHITE    ; 
BH_SprtColorPlaneExpl_Off   = BLACK    ; 
BH_SprtColorTransp          = BROWN    ; 
BH_SprtColorTranspExplode   = YELLOW   ; 
BH_SprtColorTranspExpl_MC0  = ORANGE   ; 
BH_SprtColorTranspExpl_MC1  = BLACK    ; 
BH_SprtColorTranspExpl_Off  = BLACK    ; 
BH_SprtColorTankExplode     = RED      ; 
BH_SprtColorBeachTank       = ORANGE   ; 
BH_SprtColorBeachTankE      = PURPLE   ; 
BH_SprtColorBeachCannon     = BROWN    ; 
BH_SprtColorBeachMacGun     = BROWN    ; 
BH_SprtColorBeachTurret     = BLUE     ; 
BH_SprtColorBeachTankShot   = BLACK    ; 
BH_SprtColorBeachTankShotE  = BLACK    ; 
BH_SprtColorHillMyShot      = BLACK    ; 
BH_SprtColorHillHitExplode  = YELLOW   ; 
BH_SprtColorHillCapExplode  = ORANGE   ; 
BH_SprtColorHillCapRuin     = BLACK    ; 
BH_SprtColorHillCapPieces   = BROWN    ; 
BH_SprtColorHillResignFlag  = WHITE    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Colors: Status
; -------------------------------------------------------------------------------------------------------------- ;
BH_StatColorPlayer          = YELLOW   ; 
BH_StatColorLevel           = WHITE    ; 
BH_StatColorScore           = CYAN     ; 
BH_StatColorTanks           = LT_BLUE  ; 
BH_StatColorTankText        = WHITE    ; 
BH_StatColorShipsGame       = LT_BLUE  ; 
BH_StatColorShipsCavePass   = WHITE    ; 
BH_StatColorStatusBase      = GREY     ; 
BH_StatColorStatusBoxAdd    = LT_GREEN ; 
BH_StatColorAmmoTank        = ORANGE   ; 
BH_StatColorAmmoTankTxt     = CYAN     ; 
BH_StatColorAmmoShip        = BROWN    ; 
BH_StatColorAmmoShipTxt     = CYAN     ; 
BH_StatColorAmmoFlack       = LT_GREEN ; 
BH_StatColorAmmoFlackTxt    = YELLOW   ; 
BH_StatColorDegElev         = WHITE    ; 
BH_StatColorArialRecTxt     = WHITE    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Start Positions
; -------------------------------------------------------------------------------------------------------------- ;
BH_SprtStartPlanePosX       = $a8      ; 
BH_SprtStartPlanePosY       = $8c      ; 
BH_SprtTurnPlanePosX        = $84      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter Numbers
; -------------------------------------------------------------------------------------------------------------- ;
BH_ChapterBayAreaMap        = $01
BH_ChapterCaveCrossings     = $02
BH_ChapterPlaneShootOut     = $03
BH_ChapterShipShootOut      = $04
BH_ChapterTanksOnBeach      = $05
BH_ChapterStormTheHill      = $06
; -------------------------------------------------------------------------------------------------------------- ;
; Sprite Pointers and Storage
; -------------------------------------------------------------------------------------------------------------- ;
BH_SpriteDataLen            = $40
BH_SpriteStore              = BH_MemSprites

BH_SpritePointers_Chr       = BH_MemCharSet + $07f8   ; 

BH_SpritePointers_A         = BH_Scrn_Gfx_A + $03f8     ; $4bf8
BH_SpritePointer00_A        = BH_SpritePointers_A + $00 ; $4bf8
BH_SpritePointer01_A        = BH_SpritePointers_A + $01 ; $4bf9
BH_SpritePointer02_A        = BH_SpritePointers_A + $02 ; $4bfa
BH_SpritePointer03_A        = BH_SpritePointers_A + $03 ; $4bfb
BH_SpritePointer04_A        = BH_SpritePointers_A + $04 ; $4bfc
BH_SpritePointer05_A        = BH_SpritePointers_A + $05 ; $4bfd
BH_SpritePointer06_A        = BH_SpritePointers_A + $06 ; $4bfe
BH_SpritePointer07_A        = BH_SpritePointers_A + $07 ; $4bff

BH_SpritePointers_B         = BH_Scrn_Gfx_B + $03f8     ; $4ff8
BH_SpritePointer00_B        = BH_SpritePointers_B + $00 ; $4ff8
BH_SpritePointer01_B        = BH_SpritePointers_B + $01 ; $4ff9
BH_SpritePointer02_B        = BH_SpritePointers_B + $02 ; $4ffa
;BH_SpritePointer03_B        = BH_SpritePointers_B + $03 ; $4ffb - not directly used
;BH_SpritePointer04_B        = BH_SpritePointers_B + $04 ; $4ffc
;BH_SpritePointer05_B        = BH_SpritePointers_B + $05 ; $4ffd
;BH_SpritePointer06_B        = BH_SpritePointers_B + $06 ; $4ffe
;BH_SpritePointer07_B        = BH_SpritePointers_B + $07 ; $4fff
; -------------------------------------------------------------------------------------------------------------- ;
; C64
; -------------------------------------------------------------------------------------------------------------- ;
C64_CINV_LO                 = $0314                   ; Vector to IRQ Interrupt Routine - lo
C64_CINV_HI                 = $0315                   ; Vector to IRQ Interrupt Routine - hi
C64_CBINV_LO                = $0316                   ; Vector to BRK Instruction Interrupt - lo
C64_CBINV_HI                = $0317                   ; Vector to BRK Instruction Interrupt - hi
C64_NMINV_LO                = $0318                   ; Vector to NMI Interrupt Routine - lo
C64_NMINV_HI                = $0319                   ; Vector to NMI Interrupt Routine - hi
; -------------------------------------------------------------------------------------------------------------- ;
; Misc
; -------------------------------------------------------------------------------------------------------------- ;
Kernel_Vectors              = $ff00                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
